% Generate function for SERT model driven by Na and K, see Rudnick2019, extended to 2 substrates 

clear
syms Xt JANaX JBNaX JKX CK1 CNa1 CA1 CB1 CKX1 CX1 CNaX1 CANaX1 CBNaX1 CK2 CNa2 CA2 CB2 CANaX2 CBNaX2 CAX2 CBX2 CX2 CKX2 KK1 KNa1 KA1 KB1 KK2 KNa2A KNa2B KA2 KB2 kANaX12 kANaX21 kBNaX12 kBNaX21 kKX12 kKX21

S=solve(CK1*CX1/(KK1*CKX1)==1, CNa1*CX1/(KNa1*CNaX1)==1, CA1*CNaX1/(KA1*CANaX1)==1, CB1*CNaX1/(KB1*CBNaX1)==1, CK2*CX2/(KK2*CKX2)==1, CNa2*CAX2/(KNa2A*CANaX2)==1, CNa2*CBX2/(KNa2B*CBNaX2)==1, CA2*CX2/(KA2*CAX2)==1, CB2*CX2/(KB2*CBX2)==1, CKX1+CX1+CNaX1+CANaX1+CBNaX1+CANaX2+CBNaX2+CAX2+CBX2+CX2+CKX2-Xt==0, JANaX+JBNaX+JKX==0, kANaX12*CANaX1-kANaX21*CANaX2-JANaX==0, kBNaX12*CBNaX1-kBNaX21*CBNaX2-JBNaX==0, kKX12*CKX1-kKX21*CKX2-JKX==0, CKX1,CX1,CNaX1,CANaX1,CBNaX1,CANaX2,CBNaX2,CAX2,CBX2,CX2,CKX2,JANaX,JBNaX,JKX);
S.JANaX
S.JBNaX

%create function file:
f=matlabFunction(S.JANaX,'file','FacfuncJANaX_2substr');
f=matlabFunction(S.JBNaX,'file','FacfuncJBNaX_2substr');
